/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class ECDSAPrivateKey
extends PrivateKey {
    protected ByteArrayAttribute ecdsaParams_;
    protected ByteArrayAttribute value_;

    public ECDSAPrivateKey() {
        this.keyType_.setLongValue(Key.KeyType.ECDSA);
    }

    protected ECDSAPrivateKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.ECDSA);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.ecdsaParams_ = new ByteArrayAttribute(Attribute.ECDSA_PARAMS);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        ECDSAPrivateKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        ECDSAPrivateKey eCDSAPrivateKey = (ECDSAPrivateKey)super.clone();
        eCDSAPrivateKey.ecdsaParams_ = (ByteArrayAttribute)this.ecdsaParams_.clone();
        eCDSAPrivateKey.value_ = (ByteArrayAttribute)this.value_.clone();
        ECDSAPrivateKey.putAttributesInTable(eCDSAPrivateKey);
        return eCDSAPrivateKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof ECDSAPrivateKey) {
            ECDSAPrivateKey eCDSAPrivateKey = (ECDSAPrivateKey)object;
            bl = this == eCDSAPrivateKey || super.equals(eCDSAPrivateKey) && this.ecdsaParams_.equals(eCDSAPrivateKey.ecdsaParams_) && this.value_.equals(eCDSAPrivateKey.value_);
        }
        return bl;
    }

    public ByteArrayAttribute getEcdsaParams() {
        return this.ecdsaParams_;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new ECDSAPrivateKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(ECDSAPrivateKey eCDSAPrivateKey) {
        if (eCDSAPrivateKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        eCDSAPrivateKey.attributeTable_.put(Attribute.ECDSA_PARAMS, eCDSAPrivateKey.ecdsaParams_);
        eCDSAPrivateKey.attributeTable_.put(Attribute.VALUE, eCDSAPrivateKey.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.ecdsaParams_);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("ECDSA Params (DER, hex): ");
        stringBuffer.append(this.ecdsaParams_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Private Value d (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

